// Platformer.js //
// RadLib | 2008 //

function PlatformerEngine()
{
	if (!this instanceof PlatformerEngine) return new PlatformerEngine();
	
	this.input = {};
	this.obstructedEntity = "";
	this.topTile = "";
	this.bottomTile = "";
	this.tile = "";
	this.paused = false;
	this.lockControl = false;
	this.jumped = true;
	this.gravity = true;
	this.hitting = false;
	this.falling = false;
	this.climbing = false;
	this.upPressed = false;
	this.downPressed = false;

	// user setable engine obstruction functions //
	this.onTopHit = function(){};
	this.onSideHit = function(){};
	this.onBottomHit = function(){};
	this.onFallOut = function(){};
	
	// user setable engine control functions //
	this.onJump = function(){};
	this.onLand = function(){};
	this.onFall = function(){};
	//this.onRun = function(){};
	
	// user setable engine keys //
	this.runKey = KEY_SHIFT;
	this.jumpKey = KEY_UP;
	this.leftKey = KEY_LEFT;
	this.rightKey = KEY_RIGHT;
	
	BindKey(KEY_UP, '', '');
	BindKey(KEY_DOWN, '', '');
	BindKey(KEY_LEFT, '', '');
	BindKey(KEY_RIGHT, '', '');
}

PlatformerEngine.prototype.update = function()
{
	if (this.paused) return;
	if (!DoesPersonExist(this.input.name)) return;
	
	this.input.y = GetPersonY(this.input.name);
	this.input.x = GetPersonX(this.input.name);
	this.input.direction = GetPersonDirection(this.input.name);
	if (Math.floor(this.input.x/16) > 0 && Math.floor(this.input.y/16) > 0
			&& Math.floor(this.input.x/16) < GetLayerWidth(0)-1 && Math.floor(this.input.y/16) < GetLayerHeight(0)-1)
	{
		this.tile = GetTileName(GetTile(Math.floor(this.input.x/16),
			Math.floor(this.input.y/16), GetPersonLayer(this.input.name)));
		this.topTile = GetTileName(GetTile(Math.floor(this.input.x/16),
			Math.floor(this.input.y/16)-1, GetPersonLayer(this.input.name)));
		this.bottomTile = GetTileName(GetTile(Math.floor(this.input.x/16),
			Math.floor(this.input.y/16)+1, GetPersonLayer(this.input.name)));
	}

	if (!IsPersonObstructed(this.input.name, this.input.x, this.input.y+1) && !this.input.stop && this.gravity)
	{
		if (this.input.yv < 2) this.input.yv += 0.15;
		else this.input.yv = 2, this.falling = true, this.onFall();
		SetPersonY(this.input.name, this.input.y+this.input.yv);
	}
	
	if (IsPersonObstructed(this.input.name, this.input.x, this.input.y+1))
	{
		if (this.jumped)
		{
			this.jumped = false;
			this.input.yv = 2
			this.hitting = false;
			this.falling = false;
		}
		var name = GetObstructingPerson(this.input.name, this.input.x, this.input.y+1);
		if (name != "") { this.obstructedEntity = name; this.onBottomHit(); }
	}
	
	if (IsPersonObstructed(this.input.name, this.input.x, this.input.y-1))
	{
		this.input.stop = true;
		SetPersonY(this.input.name, this.input.y+2);
		this.input.yv = 2;
		var name = GetObstructingPerson(this.input.name, this.input.x, this.input.y-1);
		if (name != "" && !this.falling && !this.hitting)
		{
			this.obstructedEntity = name;
			this.hitting = true;
			this.onTopHit();
		}
	}
	else this.input.stop = false;
	
	if (IsPersonObstructed(this.input.name, this.input.x+1, this.input.y))
	{
		var name = GetObstructingPerson(this.input.name, this.input.x+1, this.input.y);
		if (name != "") { this.obstructedEntity = name; this.onSideHit(); }
	}
	
	if (IsPersonObstructed(this.input.name, this.input.x-1, this.input.y))
	{
		var name = GetObstructingPerson(this.input.name, this.input.x-1, this.input.y);
		if (name != "") { this.obstructedEntity = name; this.onSideHit(); }
	}
	
	if (this.tile != "ladder" && this.topTile != "ladder" && this.bottomTile != "ladder")
	{
		this.gravity = true;
		this.climbing = false;
		IgnoreTileObstructions(this.input.name, false);
	}
	else if (IsKeyPressed(this.jumpKey) && !this.lockControl && !this.jumped)
	{
		this.gravity = false;
		this.climbing = true;
		IgnoreTileObstructions(this.input.name, true);
		SetPersonDirection(this.input.name, "north");
		QueuePersonCommand(this.input.name, COMMAND_MOVE_NORTH, false);
	}

	if (IsKeyPressed(this.jumpKey) && !this.jumped && this.input.yv == 2
			&& IsPersonObstructed(this.input.name, this.input.x, this.input.y+1) && !this.lockControl && this.gravity)
	{
		if (!this.upPressed) this.jump(-4);
		this.upPressed = true;
		this.onJump();
	}
	
	if (!IsKeyPressed(this.jumpKey) && !this.jumped
			&& IsPersonObstructed(this.input.name, this.input.x, this.input.y+1) && this.gravity)
	{
		this.upPressed = false;
		this.onLand();
	}
	
	if (IsKeyPressed(this.runKey) && !this.lockControl) SetPersonSpeed(this.input.name, 2);
	else SetPersonSpeed(this.input.name, 1);
	
	if (IsKeyPressed(this.leftKey) && !IsKeyPressed(this.rightKey) && !this.lockControl)
	{
		if (!this.climbing)
		{
			this.upSlope();
			SetPersonDirection(this.input.name, this.input.west);
		}
		QueuePersonCommand(this.input.name, COMMAND_MOVE_WEST, false);
	}
	
	if(IsKeyPressed(this.rightKey) && !IsKeyPressed(this.leftKey) && !this.lockControl)
	{
		if (!this.climbing)
		{
			this.upSlope();
			SetPersonDirection(this.input.name, this.input.east);
		}
		QueuePersonCommand(this.input.name, COMMAND_MOVE_EAST, false);
	}
	
	this.deObstruct();
	
	if (this.input.y > GetLayerHeight(0)*16+96) this.onFallOut();
}

PlatformerEngine.prototype.jump = function(num)
{
	SetPersonY(this.input.name, this.input.y-2);
	this.input.yv = num;
	this.jumped = true;
}

PlatformerEngine.prototype.deObstruct = function()
{
	if (IsPersonObstructed(this.input.name, this.input.x, this.input.y) && !this.input.stop)
		SetPersonY(this.input.name, this.input.y-1);
}

PlatformerEngine.prototype.upSlope = function()
{
	if (IsPersonObstructed(this.input.name, this.input.x+1, this.input.y) && this.input.direction == "east")
	{
		SetPersonSpeed(this.input.name, 1);
		SetPersonY(this.input.name, this.input.y-1);
		QueuePersonCommand(this.input.name, EAST, true);
	}
	if (IsPersonObstructed(this.input.name, this.input.x-1, this.input.y) && this.input.direction == "west")
	{
		SetPersonSpeed(this.input.name, 1);
		SetPersonY(this.input.name, this.input.y-1);
		QueuePersonCommand(this.input.name, WEST, true);
	}
}